﻿' ReadSettings, Version 1.0.0, vom 21.01.2009
'
' Liest alle Settings aus einer Datei
'
' Copyright by Frank Schöneck, 2009
' letzte Änderung: Frank Schöneck, 21.01.2009 V1.0.0, Projektbeginn
'
' für Eplan Electric P8, ab V1.9.5
'
'
Public Class ReadSettings
	<Start> _
		Public Sub MyFunction()

        Dim strSettingsDatei As String
				Dim oSettings As New Eplan.EplApi.Base.Settings()
				
				'Ordner und Name von Einstellungsdatei abfragen
				strSettingsDatei = DialogDateiOeffnen
				If strSettingsDatei = Nothing then Exit Sub
				
				oSettings.ReadSettings(strSettingsDatei)
				
				'Fertig
				MessageBox.Show("Einstellungen wurden aus Datei '" & strSettingsDatei & "' eingelesen.", "WriteSettings", MessageBoxButtons.OK, MessageBoxIcon.Information)
				
    End Sub 'MyFunction
		
	Public Function DialogDateiOeffnen
		'Eine neue openFileDialog-Klasse instanzieren
		Dim dateiOeffnenDialog As New OpenFileDialog
	
		'Alles Weitere bezieht sich nun darauf, bis ‘End With’
		With dateiOeffnenDialog
			.Title = "Eplan P8 Einstellungen einlesen aus" ' Titelzeile
			.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal) ' das Ausgangsverzeichnis
			.RestoreDirectory = True ' das vom Benutzer zuletzt ausgewählte Verzeichnis wird wieder hergeholt
			.Multiselect = False 'erlaubt eine Mehrfachauswahl
			.CheckPathExists = True ' überprüft, ob der Pfad existiert
			.FileName = "Eplan P8 Einstellungen.xml" 'Dateiname vorbelegen
			.DefaultExt = "*.xml"   ' Standardendung
			.Filter = "XML-Dateien (*.xml)|*.xml|Alle Dateien (*.*)|*.*" 'Alle angezeigten Dateifilter werden folgendermaßen angegeben
			.FilterIndex = 1
			.AddExtension = True 'wenn keine Erweiterung angegeben wird, automatisch hinzufügen
		
			'Diese Enum-Variable nimmt das Dialogergebnis (OK, Abbrechen) entgegen
			Dim dialogErgebnis As DialogResult = .ShowDialog
		
			'Falls das Dialogergebnis 'Abbrechen' war, 
			If dialogErgebnis = Windows.Forms.DialogResult.Cancel Then
				Exit Function
			End If
			DialogDateiOeffnen = .FileName
		End With
	End Function
End Class
	 